<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Professeur extends Model 
{

    protected $table = 'professeurs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nom', 'prenom', 'password', 'email');

    public function honoraires()
    {
        return $this->belongsToMany('App\Models\Honoraires');
    }

    public function matieres()
    {
        return $this->morphToMany('App\Models\Matiere', 'matiereable');
    }

    public function contrats()
    {
        return $this->belongsToMany('App\Models\Contrats');
    }

    public function photos()
    {
        return $this->hasMany('App\Models\Medias');
    }

}